<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage models
* @filesource
*//** */


/**
* @package direct-as-a-service
* @subpackage models
*/
class PointsOfOriginModel extends CI_Model {
	
    function __construct() {
        parent::__construct();
		$this->load->database();
    }
    
    function get_message_counts_grouped_by_application($application_id = null, $between = null, $order, $dir, $destination_page, $items_per_page, $is_export) {
    	$delimiter = '@';
    	$http = 'http://';
    	$https = 'https://';
    	$right_angle_bracket = '>';
    	$www = 'www.';
    	
    	$sql_points_of_origin = '';
    	$select_from_points_of_origin = '';
    	if(!$is_export) {
    		$select_from_points_of_origin = ' * ';
    	}
    	else {
    		$select_from_points_of_origin = ' application_name, message_count ';
    	}
    	
    	if(isset($application_id) && isset($order) && isset($dir)) {
    		$sql_points_of_origin = 'select ' . $select_from_points_of_origin . ' from (select ROW_NUMBER() over (order by ' . $order . ' ' . $dir .') as row, * ';
    	}
    	else {
    		$sql_points_of_origin = 'select ' . $select_from_points_of_origin . ' from (select ROW_NUMBER() over (order by application_name asc) as row, * ';
    	}
    	
    	/*$sql_points_of_origin .= 'from (select count(*) message_count, app.name application_name, app.id application_id ' .
								'from mail_log ml, application app ' .
								'where replace(LTRIM(SUBSTRING(ml.sender, CHARINDEX( ' . $this->db->escape($delimiter) . ', ml.sender)+1,len(ml.sender))), ' . $this->db->escape($right_angle_bracket) . ' , ' . $this->db->escape('') . ') = ' . 
    							'replace(replace(replace(app.url, ' . $this->db->escape($https) . ', ' . $this->db->escape('') . '), ' . $this->db->escape($www) . ', ' . $this->db->escape('') . '), ' . $this->db->escape($http) . ', ' . $this->db->escape('') . ') ' .
    							'and ml.success = 1 ';*/
    	$sql_points_of_origin .= 'from (select COUNT(r.id) message_count, a.name application_name, a.id application_id from request r, application a '. 
    								'where r.application_id = a.id and upper(r.call) like upper(\'%send%\') '. 
    								'and r.response_code = 200 ';

    	if($between != null) {
    		foreach ($between as $key => $value){//this if for anything that has an upper and lower boundary (ie date)
    			if($value['end']){
    				$sql_points_of_origin .= "AND (r.". $key ." <= ".$this->db->escape($value['end']).") ";
    			}
    			if($value['start']){
    				$sql_points_of_origin .= "AND (r.". $key ." >= ".$this->db->escape($value['start']). ")";
    			}
    		}
    	}
    	
    	$sql_points_of_origin .= ' group by a.name, a.id) as temp) as points_of_origin ' .
    							 ' where 1 = 1 ';
    	if($application_id != '(ALL)' && $application_id != null) {
	    		$sql_points_of_origin .= ' and application_id = ' . $application_id;
	    	}
	    	
	    $total_size = sizeof($this->db->query($sql_points_of_origin)->result());
    	if(!$is_export) {
	    	$start = ($destination_page - 1) * $items_per_page + 1;
	    	if($start > $total_size) {
	    		$start = 1;
	    	}
	    	$sql_points_of_origin .= ' and row >= '.$this->db->escape($start).' and row < '.$this->db->escape($start+$items_per_page);
    	}
    	else {
    		$sql_points_of_origin .= ' and row >= 1 ' ;
    	}

    	
    	$response = $this->db->query($sql_points_of_origin)->result();
    	
    	return array('total_size'=>$total_size, 'list'=>$response);
    }
    
    
}